<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('city_id')->nullable();
            $table->unsignedBigInteger('grade_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->text('cover_letter')->nullable();
            $table->string('experience')->nullable();
            $table->string('title')->nullable();
            $table->string('shape')->nullable();
            $table->string('segment')->nullable();
            $table->string('stock_type')->nullable();
            $table->string('qty_unit')->nullable();
            $table->string('size_unit')->nullable();
            $table->string('qty')->nullable();
            $table->string('size')->nullable();
            $table->string('description')->nullable();
            $table->string('address')->nullable();
            $table->boolean('status')->nullable();
            $table->unsignedBigInteger('image_id')->nullable();
            $table->json('other_image_id')->nullable();
            $table->unsignedBigInteger('cv_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('posts');
    }
};
