<?php

namespace App\Services;
use App\Services\UserService;

use App\Models\User;

use Illuminate\Support\Facades\Http;

class SmsService
{

    protected $username;
    protected $password;
    protected $senderId;
    protected $apiUrl;

    public function __construct()
    {
        $this->username = env('KIT19_USERNAME');
        $this->password = env('KIT19_PASSWORD');
        $this->senderId = env('KIT19_SENDER_ID');
        $this->apiUrl = env('KIT19_API_URL');
    }

   
    
    public static function loginOtp(array $params){

        $message =  'Thank you for your registration with steelreporter.com. Your otp is '.$params['otp'].'. DO NOT share with anyone. The otp expires in 10 mins. TSR GLOBAL';
        $tamplate = '1707172344793296239';
        //$to = implode(', ', $usersPhone);

        //return $message;

        $smsService = new self();
        return $smsService->sendSms((int)$params['phone'], $tamplate, $message);


    }

    public static function newUpdate(array $params){
        $userService = app(UserService::class);
        $userParameter = [
            'user_type' => $params['user_type'],
            'product_id' => $params['product_id'],
            'unit_id' => $params['unit_id'],
        ];
        $usersPhone = $userService->getUsersPhone($userParameter);
        $to = implode(',', $usersPhone);
        $data = $params['data'];
        $message =  'Khandelia Oil & General Mills Pvt. Ltd.- Product - '.$data->product->product_name.',Rate- '.$data->demand_rate.'/MT(EX-Factory),Pack-'. $data->product_feature;
        $tamplate = '1207172050383540522';

        $smsService = new self();
        return $smsService->sendSms($to, $tamplate, $message);
    }
    
    public static function bidToManager(array $params){
        $userService = app(UserService::class);
        $userParameter = [
            'user_type' => $params['user_type'],
            'product_id' => $params['product_id'],
            'unit_id' => $params['unit_id'],
        ];
        $usersPhone = $userService->getUsersPhone($userParameter);
        $to = implode(',', $usersPhone);
        $data = $params['data'];
        $message =  'Khandelia Oil & General Mills Pvt. Ltd. New bid from '.$data->user->name.' for Product - '.$data->product->product_name.'. Rate- ₹'.$data->offer_rate.'/'.$data->accept_rate_matric->metric_short_name. ' Qty- '.$data->offer_qty.'/'.$data->accept_qty_matric->metric_short_name. '. Update final rates, Thank you.';
        $tamplate = '1207172923576763075';


        $smsService = new self();
        return $smsService->sendSms($to, $tamplate, $message);

    }

    public static function finalUpdate(array $params){
        $userService = app(UserService::class);
        $usersPhone = $userService->getUserByIdPhone($params['user_id']);
        $data = $params['data'];
        $message =  'Khandelia Oil & General Mills Pvt. Ltd.- Final update for Product- '.$data->product->product_name.', Final Rate- ₹'.$data->final_rate.'/'.$data->accept_rate_matric->metric_short_name. ' and Final Qty- '.$data->final_qty.'/'.$data->accept_qty_matric->metric_short_name. ', Approve Now';
        $tamplate = '1207172889249530745';

        $smsService = new self();
        return $smsService->sendSms($usersPhone, $tamplate, $message);
    }

    public static function rejectByCustomer(array $params){
        $userService = app(UserService::class);
        $userParameter = [
            'user_type' => $params['user_type'],
            'product_id' => $params['product_id'],
            'unit_id' => $params['unit_id'],
        ];
        $usersPhone = $userService->getUsersPhone($userParameter);
        $to = implode(',', $usersPhone);
        $data = $params['data'];
        $message =  'Khandelia Oil & General Mills Pvt. Ltd.- Bid Rejected by '.$data->user->name.' for Product - '.$data->product->product_name.'. Rate- ₹'.$data->final_rate.'/'.$data->accept_rate_matric->metric_short_name. ' Qty- '.$data->final_qty.'/'.$data->accept_qty_matric->metric_short_name. '. Thank you.';
        $tamplate = '1207172923032015040';

        $smsService = new self();
        return $smsService->sendSms($to, $tamplate, $message);
    }

    public static function approvedMessage(array $params){
        $userService = app(UserService::class);
        $userParameter = [
            'user_type' => $params['user_type'],
            'product_id' => $params['product_id'],
            'unit_id' => $params['unit_id'],
        ];
        $usersPhone = $userService->getUsersPhone($userParameter);
        $to = implode(',', $usersPhone);
        $data = $params['data'];
        $message =  'Khandelia Oil & General Mills Pvt. Ltd.- '.$data->user->name.' has approved the bid for Product - '.$data->product->product_name.'. Rate-₹'.$data->final_rate.'/'.$data->accept_rate_matric->metric_short_name. ' Qty- '.$data->final_qty.'/'.$data->accept_qty_matric->metric_short_name. '. Thank you.';
        $tamplate = '1207172923108616741';

        $smsService = new self();
        return $smsService->sendSms($to, $tamplate, $message);
    }

    public static function thankYouMessage(array $params){
        $userService = app(UserService::class);
        $usersPhone = $userService->getUserByIdPhone($params['user_id']);
        $data = $params['data'];
        $message =  $data->user->name.', we are pleased to inform you that the bid for the product '.$data->product->product_name.' has been approved. The Final Rate is ₹'.$data->final_rate.'/'.$data->accept_rate_matric->metric_short_name. ' Qty- '.$data->final_qty.'/'.$data->accept_qty_matric->metric_short_name. '. Thank you for your approval, from Khandelia Oil & General Mills Pvt. Ltd.';
        $tamplate = '1207172923385676697';

        $smsService = new self();
        return $smsService->sendSms($usersPhone, $tamplate, $message);
    }




    public function sendSms($to, $templateId, $message)
    {
        $url = $this->apiUrl;

        //return 'done';
        
        $response = Http::get($url, [
            'username' => $this->username,
            'password' => $this->password,
            'sender'   => $this->senderId,
            'to'       => $to,
            'dlttemplateid' => $templateId,
            'message'  => $message, // handle special characters
            'priority' => 1,
            'dnd'      => 1,
            'unicode'  => 0
        ]);

        if ($response->failed()) {
            // Handle failure
            return new \Exception('Failed to send SMS: ' . $response->body());
        }else{
            return 'send';
        }

        return $response;
       
    }


}
