<?php

namespace App\Services;
use App\Services\UserService;

use App\Models\User;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Exception;

class EmailService
{
   
    
    public static function loginOtp(array $params){

        $message =  '<html>
        <head>
        <style>
          .top-border{
            width:100%;
            height:10px;
            background: #1C1B1F;
            box-sizing: border-box;
          }
          .container{
            with:100%;
            display: block;
            min-height:500px;
            background:#ddd;
            padding-top:80px;
            padding-bottom:80px;
            padding-left:20px;
            padding-right:20px;
            font-family: arial;
            box-sizing: border-box;
          }
          .padding-box{
            width: 100%;
            padding:30px;
            font-family: arial;
            display: block;
            box-sizing: border-box;
            
          }
          .inner-container{
            overflow: hidden;
            max-width: 600px;
            background:#fff;
            margin:0px auto;
            border-radius:15px;
            min-height:300px;
            font-family: arial;
            box-sizing: border-box;
          }
          .mail-footer{
            display: block;
            width: 600px;
            background:#fff;
            margin:0px auto;
            border-radius:15px;
            padding:30px;
            min-height:50px;
            text-align: center;
            font-family: arial;
            box-sizing: border-box;
          }
          .mail-footer-content{
            font-size:12px;
            max-width: 90%;
            margin:0px auto;
            color:#777;
            font-family: arial;
          }
          .mail-text{
            font-size:12px;
            max-width: 90%;
            color:#777;
            font-family: arial;
          }
          .text-center{
           margin:0px auto;
           text-align: center;
           margin-bottom:15px;
          }
        </style>
        </head>
        <body>
          <div class="container">
            <div class="inner-container">
              <div class="top-border"></div>
              <div class="padding-box">
                <p class="text-center" >
                  <img src="'.asset('images/Steel-logo.jpg').'" style="border-radius:20px;margin-top:0px;width:200px">
                </p>
                <br><br><br>
                <p>Here is your One Time Password to Log in to your Steel Repoter Account:</p>
                <h2>'.$params['otp'].'</h2>
                <p>This otp valid for 10 minutes</p>
                <p class="mail-text">If this is not you, Ignore this email or contact us on thesteelreporter@gmail.com.</p>
              </div>
            </div>
            <br>
            <div class="mail-footer">
              <p class="mail-footer-content">This is an automated message. Please do not reply to this mail. If you wish to get in touch, please mail us at thesteelreporter@gmail.com. </p>
            </div>
          </div>
          
        </body>
        
      </html>';

        $emailService = new self();
        return $emailService->sendEmail($params['email'], 'The Steel Reporter - Your OTP for Secure Login', $message);
    }



    public function sendEmail($to, $subject, $messageBody, $bccMails = 0)
    {
      $headers = "MIME-Version: 1.0" . "\r\n";
      $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

      // Additional headers
      $headers .= 'From: donotreply@steelreporter.com' . "\r\n";
      $headers .= 'Reply-To: donotreply@steelreporter.com' . "\r\n";

      // Add BCC recipients
      $bcc = $bccMails; // Add multiple BCC recipients
      if($bccMails !== 0){
        $headers .= 'Bcc: ' . $bcc . "\r\n";
      }

      // Send the email
      if(mail($to, $subject, $messageBody, $headers)) {
          return 'Email sent successfully!';
      } else {
          return 'Failed to send email.';
      }
    }


}
