<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PriceData extends Model
{
    use HasFactory;
    protected $fillable = [
        'id',
        'price_id',
        'price_city_id',
        'rate',
        'record_data',
    ];

    public function city_data()
    {
        return $this->belongsTo(PriceCity::class, 'price_city_id');
    }
    
    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }


}
