<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Manager extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'alc_list',
        'profile_pic_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    public function roleData()
    {
        return $this->belongsTo(Role::class);
    }

    public function profile_pic()
    {
        return $this->belongsTo(Media::class, 'profile_pic_id');
    }

    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

}
