<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DailyUpdate extends Model
{
    use HasFactory;
    protected $fillable = [
        'dailyupdate_name',
        'dailyupdate_description',
        'dailyupdate_slug',
        'dailyupdate_category_id',
        'dailyupdate_image_id',
        'status'
    ];
    public function category()
    {
        return $this->belongsTo(DailyUpdateCategory::class,'dailyupdate_category_id');
    }
    
    public function post_image()
    {
        return $this->belongsTo(Media::class, 'dailyupdate_image_id');
    }

    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }
   
}
