<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'cover_pic_id',
        'profile_pic_id',
        'user_type_id',
        'company_name',
        'whatsapp_number',
        'official_email',
        'country_id',
        'city_id',
        'state_id',
        'business_id',
        'product_id',
        'address',
        'pincode'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function cover_pic()
    {
        return $this->belongsTo(Media::class, 'cover_pic_id');
    }

    public function profile_pic()
    {
        return $this->belongsTo(Media::class, 'profile_pic_id');
    }

    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('M, d Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('M, d Y H:i a');
    }
}