<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class Subscription extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'subscription_name' => $this->subscription_name,
            'subscription_duration' => $this->subscription_duration,
            'subscription_rate' => $this->subscription_rate,
            'subscription_description' => $this->subscription_description,
            'subscription_image_id' => $this->subscription_image_id,
            'subscription_image' => $this->subscription_image ? url(Storage::url($this->subscription_image->webp_path)) : null,
            'subscription_thumb_image' => $this->subscription_image ? url(Storage::url($this->subscription_image->thumb_path)) : null,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
