<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class Specification extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'grade_id' => $this->grade_id,
            'grade_name' => $this->grade_data ? $this->grade_data->grade_name  : 'anonymous',
            'group_name' => $this->group_data ? $this->group_data->group_name  : 'anonymous',
            'specification_data' => SpecificationData::collection($this->specification_data),
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ]; 
    }
}
