<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PriceData extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'price_city_id' => $this->price_city_id,
            'city_name' => $this->city_data ? $this->city_data->city_name : 'anonymous',
            'rate' => $this->rate,
            'record_date' => $this->record_date,
            'created_at' => $this->created_at,
            'float_record_date' => $this->record_date
                ? (float) (strtotime($this->record_date) * 1000) // Convert record_date to milliseconds
                : ($this->created_at
                    ? (float) (strtotime($this->created_at) * 1000) // Fallback to created_at if record_date is null
                    : null),
            'float_rate' => (float) $this->rate,
        ];
        
    }
}