<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class Price extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'price_product_id' => $this->price_product_id,
            'price_country_id' => $this->price_country_id,
            'product_name' => $this->product_data ? $this->product_data->product_name  : 'anonymous',
            'country_name' => $this->country_data ? $this->country_data->country_name  : 'anonymous',
            'status' => $this->status,
            'record_date' => $this->record_date,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'price_data' => PriceData::collection($this->price_data),
            'float_record_date' => $this->record_date
                ? (float) (strtotime($this->record_date) * 1000) // Convert record_date to milliseconds
                : ($this->created_at
                ? (float) (strtotime($this->created_at) * 1000) // Fallback to created_at if record_date is null
                : null),
        ];
    }
}
