<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class Customer extends JsonResource
{
    function isCompleted($data){
        if(empty($data->name) || 
            empty($data->email) || 
            empty($data->phone) || 
            empty($data->customer->company_name) || 
            empty($data->password) || 
            empty($data->customer->country_id) ||
            empty($data->customer->state_id) ||
            empty($data->customer->city_id) ||
            empty($data->customer->address) ||
            empty($data->customer->pincode) 
        ){
            return [
                'is_completed' => false,
                'name' => empty($data->name),
                'email' => empty($data->email),
                'phone' => empty($data->phone),
                'company_name' => empty($data->customer->company_name),
                'password' => empty($data->password),
                'country' => empty($data->customer->country_id),
                'state' => empty($data->customer->state_id),
                'city' => empty($data->customer->city_id),
                'address' => empty($data->customer->address),
                'pincode' => empty($data->customer->pincode),
            ];
        }else{
            return [
                'is_completed' => true,
            ];
        }
    }

    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'status' => $this->status,
            'cover_pic_id' => $this->customer->cover_pic_id,
            'profile_pic_id' => $this->customer->profile_pic_id,
            'cover_image' => $this->customer->cover_pic ? url(Storage::url($this->customer->cover_pic->webp_path)) : null,
            'profile_image' => $this->customer->profile_pic ? url(Storage::url($this->customer->profile_pic->webp_path)) : null,
            'user_type_id' => $this->customer->user_type_id,
            'company_name' => $this->customer->company_name,
            'whatsapp_number' => $this->customer->whatsapp_number,
            'state_id' => $this->customer->state_id,
            'address' => $this->customer->address,
            'city_id' => $this->customer->city_id,
            'country_id' => $this->customer->country_id,
            'pincode' => $this->customer->pincode,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'profile_status' => $this->isCompleted($this)
        ];
    }
}
