<?php

namespace App\Http\Controllers;

use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;

use App\Models\DailyUpdateCategory;
use Illuminate\Http\Request;
use App\Http\Resources\DailyUpdateCategory as DailyUpdateCategoryCollection;

class DailyUpdateCategoryController extends Controller
{
    public function index(Request $request)
        {
          //  try {
                $limit = $request->query('limit', 10);
                $query = DailyUpdateCategory::query();
                // Get all parameters from the request
                $parameters = $request->all();

                // Loop through each parameter and apply filters to the query
                foreach ($parameters as $key => $value) {
                    // Make sure the key is not a reserved Laravel parameter
                    if ($key !== 'page' && $key !== 'limit') {
                        if (in_array($key, ['dailyupdatecategory_name'])) {
                            // Apply search functionality using 'like' for name, email, and phone
                            $query->where($key, 'like', "%$value%");
                        } else {
                            // Apply exact match for other fields
                            $query->where($key, $value);
                        }
                    }
                }
                $categories = $query->orderBy('updated_at', 'desc')->paginate($limit);
                $dailyupdatecategoryCollection = DailyUpdateCategoryCollection::collection($categories->items());

                $responseData = [
                    'records' => $dailyupdatecategoryCollection,
                    'pagination' => [
                        'current_page' => $categories->currentPage(),
                        'last_page' => $categories->lastPage(),
                        'per_page' => $categories->perPage(),
                        'total' => $categories->total(),
                    ],
                ];

                return response()->json($responseData);
          /*  } catch (QueryException $e) {
                return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
            } catch (\Exception $e) {
                return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
            }*/
        }
    
    
        /**
         * Store a newly created resource in storage.
         */
        public function store(Request $request)
        {
            try {
                $validatedData = $request->validate([
                    'dailyupdatecategory_name' => 'required',
                ]);
    
                DB::beginTransaction();
                $dailyupdatecategory = DailyUpdateCategory::create([
                    'dailyupdatecategory_name' => $request->dailyupdatecategory_name,
                    'status' => $request->status ?? true,
                ]);
     
                DB::commit();
                return response()->json(['message' => 'Post created successfully', 'record' => new DailyUpdateCategoryCollection($dailyupdatecategory)], 201);
            } catch (QueryException $e) {
                DB::rollBack();
                return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
            } catch (\Exception $e) {
                DB::rollBack();
                return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
            }
        }
    
        /**
         * Display the specified resource.
         */
        public function show($id)
        {
            try{
                $dailyupdatecategory = DailyUpdateCategory::findOrFail($id);
                return response()->json(['message' => 'Post Details Fetached successfully', 'record' => new DailyUpdateCategoryCollection($dailyupdatecategory)], 200);
            }catch (\Exception $e) {
                return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
            }
            
        }
    
    
        /**
         * Update the specified resource in storage.
         */
        public function update(Request $request, $id)
        {
            try {
                $validatedData = $request->validate([
                    'dailyupdatecategory_name' => 'required',
                ]);
    
                DB::beginTransaction();
        
                $dailyupdatecategory = DailyUpdateCategory::findOrFail($id); 
                // Update user data

                $dailyupdatecategory->dailyupdatecategory_name = $request->dailyupdatecategory_name;
                $dailyupdatecategory->status = $request->status;
                $dailyupdatecategory->save();
    
                DB::commit();
        
                return response()->json(['message' => 'Post updated successfully', 'record' => new DailyUpdateCategoryCollection($dailyupdatecategory)], 200);
            } catch (ModelNotFoundException $e) {
                DB::rollBack();
                return response()->json(['message' => 'Post not found'], 404);
            } catch (QueryException $e) {
                DB::rollBack();
                return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
            } catch (\Exception $e) {
                DB::rollBack();
                return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
            }
        }
    
        /**
         * Remove the specified resource from storage.
         */
        public function destroy($id)
        {
            try {

                $ids = explode(",",$id);
                if (!empty($ids)) {
                    // Fetch the product  with the specified IDs
                    $categories = DailyUpdateCategory::whereIn('id', $ids)->get();
                    
                    // Delete the fetched product groups
                    foreach ($categories as $dailyupdatecategory) {
                        $dailyupdatecategory->delete();
                    }
                }
                return response()->json(['message' => 'Post and associated entries deleted successfully'], 200);
            } catch (ModelNotFoundException $e) {
                DB::rollBack();
                return response()->json(['message' => 'Post not found'], 404);
            } catch (QueryException $e) {
                DB::rollBack();
                return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
            } catch (\Exception $e) {
                DB::rollBack();
                return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
            }
        }


        public function activeCategory(){
            try {
                $categories = DailyUpdateCategory::where('status',1)->get();
                //return response()->json(['records' => $categories]);

                if ($categories->isEmpty()) {
                  return response()->json(['records' => []]);
                }else{
                    return response()->json(['records' => DailyUpdateCategoryCollection::collection($categories)]);
                }
            } catch (QueryException $e) {
                return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
            } catch (\Exception $e) {
                return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
            }

        }
}
